package dev.honegger.hackvent2021.santacryptovault.services

import kotlinx.coroutines.delay
import org.springframework.stereotype.Service
import kotlin.time.Duration.Companion.milliseconds

interface HashService {
    suspend fun hash(input: String): String
}

@Service
class DefaultHashService: HashService {
    override suspend fun hash(input: String): String {
        // No actual hashing code to preserve resources
        delay(50.milliseconds)
        return input + "_hash"
    }

}
