package dev.honegger.hackvent2021.santacryptovault.controllers

import dev.honegger.hackvent2021.santacryptovault.services.VaultCode
import kotlinx.coroutines.*
import org.junit.jupiter.api.Assertions
import org.junit.jupiter.api.Disabled
import org.junit.jupiter.api.Test
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.boot.test.context.SpringBootTest
import org.springframework.http.HttpStatus
import kotlin.time.Duration.Companion.milliseconds


@SpringBootTest(
    properties = [
        "vault.secret.bestCharacter=Correct_hash",
        "vault.secret.bestWaifu=Correct_hash",
        "vault.secret.reliableGuy=Correct_hash",
        "vault.secret.bestStand=Correct_hash",
        "vault.secret.bestVillain=Correct_hash",
    ]
)
class VaultControllerTests {

    @Autowired
    lateinit var controller: VaultController

    private val dummyCode = VaultCode(
        bestCharacter = "Dio",
        bestWaifu = "Dio",
        reliableGuy = "Dio",
        bestStand = "Dio",
        bestVillain = "Dio",
    )

    @Test
    fun `too many requests get blocked`() = runBlocking {
        val firstRequests = listOf(
            async { controller.check(dummyCode) },
            async { controller.check(dummyCode) },
        )
        delay(100.milliseconds)
        val additionalRequest = controller.check(dummyCode)
        val results = firstRequests.awaitAll()
        results.forEach {
            Assertions.assertEquals(
                HttpStatus.FORBIDDEN,
                it.statusCode
            )
        }
        Assertions.assertEquals(
            HttpStatus.TOO_MANY_REQUESTS,
            additionalRequest.statusCode
        )
    }

    @Test
    @Disabled("TODO sometimes this test fails and a dummyCode passes, hopefully just a test issue")
    fun `parallel execution works`() = runBlocking {
        listOf(
            async { controller.check(dummyCode) },
            // Hint: This delay needs to be adjusted based on computer speed if you want to run the test locally
            async { delay(375.milliseconds); controller.check(dummyCode) },
        ).map {
            it.await()
        }.forEach {
            Assertions.assertEquals(
                HttpStatus.FORBIDDEN,
                it.statusCode
            )
        }
    }

}
