package dev.honegger.hackvent2021.santacryptovault

import org.springframework.boot.autoconfigure.SpringBootApplication
import org.springframework.boot.context.properties.ConfigurationProperties
import org.springframework.boot.context.properties.ConstructorBinding
import org.springframework.boot.context.properties.EnableConfigurationProperties
import org.springframework.boot.runApplication

@SpringBootApplication
@EnableConfigurationProperties(VaultProperties::class)
class SantacryptovaultApplication

@ConfigurationProperties(prefix = "vault")
@ConstructorBinding
data class VaultProperties(
    val secret: Secret = Secret(),
    val wallet: String = "<secret>",
) {
    /**
     * Contains the secret code to the wallet,
     * obviously hashed using the [dev.honegger.hackvent2021.santacryptovault.services.HashService]
     */
    data class Secret(
        val bestCharacter: String = "<secret>",
        val bestWaifu: String = "<secret>",
        val reliableGuy: String = "<secret>",
        val bestStand: String = "<secret>",
    )
}

fun main(args: Array<String>) {
    runApplication<SantacryptovaultApplication>(*args)
}
