package dev.honegger.hackvent2021.santacryptovault.services

import dev.honegger.hackvent2021.santacryptovault.VaultProperties
import mu.KotlinLogging
import org.springframework.stereotype.Service

interface VaultService {
    suspend fun checkCode(code: VaultCode): Boolean
}

private val log = KotlinLogging.logger { }

@Service
internal class DefaultVaultService(private val hashService: HashService, properties: VaultProperties) : VaultService {
    private val secret = properties.secret

    @Volatile
    private var matched: Boolean = false

    private suspend fun String.hash(): String = hashService.hash(this)

    override suspend fun checkCode(code: VaultCode): Boolean {
        matched = true
        if (code.bestCharacter.hash() != secret.bestCharacter) {
            log.warn { "Wrong bestCharacter '${code.bestCharacter}', rejecting code" }
            matched = false
        }
        if (code.bestWaifu.hash() != secret.bestWaifu) {
            log.warn { "Wrong bestWaifu '${code.bestWaifu}', rejecting code" }
            matched = false
        }
        if (code.reliableGuy.hash() != secret.reliableGuy) {
            log.warn { "Wrong reliableGuy '${code.reliableGuy}', rejecting code" }
            matched = false
        }
        if (code.bestStand.hash() != secret.bestStand) {
            log.warn { "Wrong bestStand '${code.bestStand}', rejecting code" }
            matched = false
        }
        if (code.bestVillain.hash() != "Dio".hash()) { // TODO move hashed value to configuration
            log.warn { "Wrong bestVillain '${code.bestVillain}', rejecting code" }
            matched = false
        }

        log.info { "Matched code = $matched" }

        return matched
    }
}
